###################################################
### chunk number 1: 
###################################################
options(digits=1)
options(scipen=3)


###################################################
### chunk number 2: 
###################################################
set.seed(1234)

phi<-0.85 # supervivencia por mes
cphi<-1-phi  #complemento de la supervivencia por mes
p<-0.4 #Probabilidad de recaptura
N<-200
visitas<-18


###################################################
### chunk number 3: 
###################################################
t.vida<-rexp(N,cphi)
summary(t.vida)


###################################################
### chunk number 4: 
###################################################
e.vivo<-floor(ifelse(t.vida>visitas,visitas,t.vida))
e.muerto<-ifelse(visitas-e.vivo<0,0,visitas-e.vivo)
unique(e.vivo+e.muerto)
hist.vida<-matrix(rep(NA,visitas*N),nrow=N,ncol=visitas)
for(i in 1:N){   hist.vida[i,]<-c(rep(1,e.vivo[i]),rep(0,e.muerto[i]))  }


###################################################
### chunk number 5: 
###################################################
hist.vida[1:5,]
t.vida[1:5]


###################################################
### chunk number 6: 
###################################################
detect<-matrix(rbinom(N*visitas,1,prob=p),nrow=N)


###################################################
### chunk number 7: 
###################################################
hist.encuent<-hist.vida*detect


###################################################
### chunk number 8: 
###################################################
frecuencias<-apply(hist.encuent,1,sum)
rem0<-which(frecuencias==0)
num0<-length(rem0)
ifelse(num0==0,he<-hist.encuent,he<-hist.encuent[-rem0,])
#dim(he);dim(hist.encuent)


###################################################
### chunk number 9: 
###################################################
#Royle & Dorazio 2008
library(R2WinBUGS)
library(emdbook)
nind<-nrow(he)
nyear<-ncol(he)
first<-rep(NA,nind) 
for(i in 1:nrow(he)){  
first[i]<-  (1:nyear)[!is.na(he[i,])][1] }  
Zst<-he 
Zst[Zst==0 & !is.na(Zst)]<-1 
y<-he 
data <- list ("y","first","nind","nyear") 
inits <- function(){   list (phi=runif(1),p=runif(1),z=Zst) } 
parameters <- c("phi","p")
cat(" model { phi~dunif(0,1) p~dunif(0,1)
for(i in 1:nind){ z[i,first[i]]~dbern(1)
for(j in (first[i]+1):nyear){  muy[i,j]<-p*z[i,j]   
y[i,j]~dbern(muy[i,j]) muz[i,j]<-phi*z[i,j-1]   
z[i,j]~dbern(muz[i,j]) } } } ",file="cjsmodel.txt")
ni=2000
nb=1000
nthin=2 
nc=5 
out <- bugs(data, inits, parameters, "cjsmodel.txt",
bugs.directory="/home/rem/WinBUGS14/", useWINE = T, 
n.thin=nthin,n.chains=nc, n.burnin=nb,n.iter=ni)


###################################################
### chunk number 10: 
###################################################
#print(out,digits=10)
out.mcmc<-as.mcmc.bugs(out)
summary(out.mcmc)
#print(HPDinterval(out.mcmc),digits=3)
plot(out.mcmc)


###################################################
### chunk number 11: 
###################################################
n.filas.v<-dim(he)[1]
hc.sup<-rep(0,n.filas.v)
for (i in 1:n.filas.v) hc.sup[i]<-paste(he[i,], sep="", collapse="")
unos<-rep("1;",n.filas.v)
expor.sup<-cbind(hc.sup,unos)
expor.sup[1:6,]
write.table(expor.sup,"Supervivencia_desc.inp",quote=F, row.names=F, col.names = F, sep = " ")


