###################################################
### chunk number 1: 
###################################################
set.seed(2222)
nind <- 60;m.huevos <-30; sd.huevos = 2
huevos<-round(rnorm(nind,m.huevos, sd = sd.huevos), digits=0)
trat<-sample(rep(c("BN", "MN"),c(30,30)))
bd<-data.frame(huevos,trat)



###################################################
### chunk number 2: 
###################################################
n.filas<-dim(bd)[1]

for (i in 1:n.filas){

bd$h.viab[i]<-ifelse(bd$trat[i] == "BN", rbinom(1,bd$huevos[i],0.95),rbinom(1,bd$huevos[i],0.80))}
bd[1:10,]


###################################################
### chunk number 3: 
###################################################
bd$h.nviab <- bd$huevos - bd$h.viab
bd$pviab<-bd$h.viab/bd$huevos
par(las=1)

boxplot(bd$pviab~bd$trat, ylim=c(0.5,1),


ylab= "Viabilidad de los huevos (%)")


###################################################
### chunk number 4: 
###################################################
m1<-glm(cbind(h.viab,h.nviab)~factor(trat),binomial,data=bd)
m.bin<-anova(m1,test="Chi")


###################################################
### chunk number 5: 
###################################################
library(xtable)
xtable(m.bin)


###################################################
### chunk number 6: 
###################################################
t.vida<-rexp(300,0.15)
mean(t.vida)


###################################################
### chunk number 7: 
###################################################
m.esp<-1/0.15
m.esp


###################################################
### chunk number 8: 
###################################################
par(las=1)
hist(t.vida, ylab="Frequencia de individuos", xlab="Tiempo de vida (Meses)", main= NULL, breaks=30)


###################################################
### chunk number 9: 
###################################################
corte<-seq(0,50,by=2)
t.vidacat<-cut(t.vida,corte)
t.vidafreq<-table(t.vidacat)
t.vidafreq2<-as.vector(t.vidafreq)
vivos<-300-cumsum(t.vidafreq2)
vivos0<-c(300,vivos)
par(las=2)
meses<-seq(0,50,by=2)
barplot(vivos0, xlab="Meses", ylab= "Número de sobrevivientes",cex.names=0.8, names = meses)


###################################################
### chunk number 10: 
###################################################
0.85^7


###################################################
### chunk number 11: 
###################################################
par(las=1)

curve(0.85^x,from=0,to=50, ylab= "Probabilidad de Supervivencia", xlab ="Tiempo (Meses)")
lines(c(7,7),c(0,0.3205))
text(7,-0.1,"7")


###################################################
### chunk number 12: 
###################################################
library(bbmle)
exp.fun <- function(rate){
-sum(dexp(t.vida, rate=rate, log =TRUE))
}
m.exp<-mle2(exp.fun, start=list(rate = 1/mean(t.vida)))
coef(m.exp)
confint(m.exp)


###################################################
### chunk number 13: 
###################################################
t.vidaw<-rweibull(300,shape=1.3,scale=7)
mean(t.vidaw)


###################################################
### chunk number 14: 
###################################################
tvid.weib = function(shape,scale) { scale*gamma(1+1/shape) }
tvid.weib(1.3,7)


###################################################
### chunk number 15: 
###################################################
library(bbmle)
exp.fun <- function(rate){
-sum(dexp(t.vidaw, rate=rate, log =TRUE))
}
weibull.fun <- function(shape, scale){
-sum(dweibull(t.vidaw, shape=shape, scale=scale,
log = TRUE))
}
m.exp<-mle2(exp.fun, start=list(rate = 1/mean(t.vidaw)))
m.weib<-mle2(weibull.fun, start=list(shape=1, scale = mean(t.vidaw)))
AICtab(m.exp,m.weib, base =T)
coef(m.weib)


###################################################
### chunk number 16: 
###################################################
confint(m.weib)


###################################################
### chunk number 17: 
###################################################
t.vidak<-rexp(50,rate=0.1)
#t.vidak
t.censok<-7 + 4*runif(50)
estatus<-as.numeric(t.censok > t.vidak)
preced<-pmin(t.censok,t.vidak)


###################################################
### chunk number 18: 
###################################################
telem<-data.frame(t.vidak,t.censok,preced,estatus)
telem[1:10,]


###################################################
### chunk number 19: 
###################################################
library(survival)
par(las=1)
m.km <- survfit(Surv(telem$preced,telem$estatus)~1)
plot(m.km, xlab= "Meses", ylab= "Supervivencia")


