## BIE5730 - Metodos Estatisticos em Ecologia de Populacoes
## Pos-Graduacao em Ecologia, IB-USP
## Fucoes para construcao passo a passo de distribuicao binomial e da
## respectiva funcao de verossimilhanca
## Exemplo de uso em aula_verossim.r
## Paulo Inacio Prado, prado@ib.usp.br

## Para usar estas funcoes salve este arquivo no seu diretorio de trabalho e
## dê o comando
## source("aula_verossim.r")
## Cria grafico de distribuicao de probabilidades para um mesmo
## parametro N e dois parametros p (ou seja, modelos binomiais aletranativos)
## Argumentos:
## N: parametro número de tentativas da binomial
## p1: parametro probabilidade de sucesso da primeira distribuicao
## p2: parametro probabilidade de sucesso da segunda distribuicao
plot.bino <- function(N=3,p1=1/3,p2=2/3){
  pmax <- max(c(dbinom(0:N,size=N,prob=p1),dbinom(0:N,size=N,prob=p1)))
  par(mfrow=c(1,2))
  barplot(dbinom(0:N,size=N,prob=p1), space= 0.5, names=0:N, col="blue",
          main=paste("p= ", deparse(substitute(p1))),
          xlab="N de sucessos", ylab="Probabilidade", ylim=c(0,pmax))
  barplot(dbinom(0:N,size=N,prob=p2), space= 0.5, names=0:N, col="blue",
          main=paste("p= ",deparse(substitute(p2))),
          xlab="N de sucessos", ylab="Probabilidade", ylim=c(0,pmax))
  par(mfrow=c(1,1))
}

## Grafico animado da binomial
## A cada vez que o usuario aperta uma tecla um novo grafico eh
## exibido, com um novo valor do parametro p
## Argumentos
## N: parametro número de tentativas da binomial
## pmin: valor inicial do parametro p
## pmax: valor maximo do parametro p
## int: incremento do parametro p a cada nova distribuicao
anim.bino <- function(N=3,pmin=0,pmax=1,int=0.05,decrease=FALSE){
    probs <- seq(pmin,pmax,by=int)
    if(decrease) probs <- probs[length(probs):1]
    devAskNewPage(TRUE)
    for(p in probs){
        barplot(dbinom(0:N,size=N,prob=p), space= 0.5, names=0:N, col="blue", main=paste("p= ",p),
                xlab="N de sucessos", ylab="Probabilidade", ylim=c(0,1))
    }
    devAskNewPage(FALSE)
}

## Grafico animado do perfil de verossimilhanca da binomial
## O usuario escolhe:
## N: numero de tentativas (parametro N da binomial)
## obs: n de sucessos observado (dados)
## pmin: valor inicial do parametro p
## pmax: valor maximo do parametro p
## int: incremento do parametro p a cada nova distribuicao
## Abre duas novas janelas para exibir os graficos? (default é TRUE)
## A cada vez que o usuario pressiona a tecla uma nova o parametro p é
## aumentado em mais 'int', e uma nova binomial e um valor de
## verossimilhanca sao calculados, e plotados nos dois graficos.
anim.profile <- function(N=3,obs=1,pmin=0,pmax=1,int=0.05, new.dev=TRUE){
    ## abre duas janelas graficas
    if(new.dev) {
        dev.new()
        dev.new()
    }
    LL <- function(p)prod(dbinom(obs,size=N,prob=p))
    p.mle <- sum(obs)/(N*length(obs))
    max.LL <- LL(p.mle)
    cores <- rep("darkgray",N+1)
    cores[obs+1] <- "blue"
    probs <- seq(pmin,pmax,by=int)
    plot(p.mle,max.LL, type="n",xlim=c(pmin,pmax),ylim=c(0,max.LL),xlab="Parâmetro p",
         ylab="Verossimilhança")
    dev.set(dev.prev())
    devAskNewPage(TRUE)
    for(p in probs){
        barplot(dbinom(0:N,size=N,prob=p), space= 0.5, names=0:N, col=cores,
                main=paste("p= ",p), xlab="N de sucessos",
                ylab="Probabilidade", ylim=c(0,1))
        dev.set(dev.next())
        points(p,LL(p), col="red", pch=19)
        dev.set(dev.prev())
        
    }
    devAskNewPage(FALSE)
}








